function cni=get_cni(ver,T,RH,fNO3)%MAIN get cni
%cni=get_cni(ver,T,RH,fNO3)
%ver: choose a type; available choice: 'ISR_molality','AIM_molality', and 'AIM_activity'
    %default as 'ISR_molality'
%T in K, RH in 0.6~1, fNO3=[NO3-]/Anions(aq) (ueq/ueq)
%Anions(aq) =  2*SO42- + NO3- + Cl-
%e.g., ver='ISR_molality';T=[271;298];RH=[0.7;0.8];fNO3=[0.3;0.5];
%Then run:
%cni=get_cni(ver,T,RH,fNO3)
%you should get:cni=[0.5026;0.8626];

%% input checks
    if isempty(ver),ver='ISR_molality';end
    lookup_table=['.\',ver,'.mat'];
        if ~exist(lookup_table),warning('Lookup table file missing; please update file path');return;end
    fNO3_flag=find(fNO3<0 | fNO3>1);
        if ~isempty(fNO3_flag),warning('NO3 fraction should be within 0~1; check error data');return;end
    rh_flag=find(RH<0.6|RH>0.96);
        if ~isempty(rh_flag),warning('results when RH below 0.6 might not be accurate;press any key to continue');pause;end
    if prod(size(T)~=size(RH)) | prod(size(T)~=size(fNO3))
        warning('size of input variables does not match, check again;');return;
    end
%% interp
    load(lookup_table);
    cni=interp3(Xmat,Ymat,Zmat,Vgood,T,fNO3,RH);
    if ~isempty(rh_flag)%extrap
        cni_ext=interp3(Xmat,Ymat,Zmat,Vmat,T,fNO3,RH,'spline');
        cni(find(rh_flag))=cni_ext(find(rh_flag));
    end
    
